(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     11524,        346]
NotebookOptionsPosition[      9793,        309]
NotebookOutlinePosition[     10190,        325]
CellTagsIndexPosition[     10147,        322]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
We expand the magnetization direction dependence of the conductivity tensor \
in the components of S and sort them according to their irreducible \
representations in the cubic point group for each power of S\
\>", "Text",
 CellChangeTimes->{{3.8743129644757833`*^9, 
  3.874313014412332*^9}},ExpressionUUID->"f850d626-c07d-4e60-bb0f-\
9b5f255da388"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]Oh", "[", 
   RowBox[{"Sx_", ",", "Sy_", ",", "Sz_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "1"}
      }], "\[NoBreak]", ")"}], "\[Sigma]a1g"}], "+", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"-", "Sz"}], "Sy"},
       {"Sz", "0", 
        RowBox[{"-", "Sx"}]},
       {
        RowBox[{"-", "Sy"}], "Sx", "0"}
      }], "\[NoBreak]", ")"}], "\[Sigma]t1u"}], "+", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["Sx", "2"], "-", 
         FractionBox["1", "3"]}], "0", "0"},
       {"0", 
        RowBox[{
         SuperscriptBox["Sy", "2"], "-", 
         FractionBox["1", "3"]}], "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["Sz", "2"], "-", 
         FractionBox["1", "3"]}]}
      }], "\[NoBreak]", ")"}], "\[Sigma]eg"}], "+", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"Sx", " ", "Sy"}], 
        RowBox[{"Sx", " ", "Sz"}]},
       {
        RowBox[{"Sx", " ", "Sy"}], "0", 
        RowBox[{"Sy", " ", "Sz"}]},
       {
        RowBox[{"Sx", " ", "Sz"}], 
        RowBox[{"Sy", " ", "Sz"}], "0"}
      }], "\[NoBreak]", ")"}], "\[Sigma]t2g"}], " ", "+", " ", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         RowBox[{"-", "Sz"}], 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["Sz", "2"], "-", 
           FractionBox["3", "5"]}], ")"}]}], 
        RowBox[{"Sy", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["Sy", "2"], "-", 
           FractionBox["3", "5"]}], ")"}]}]},
       {
        RowBox[{"Sz", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["Sz", "2"], "-", 
           FractionBox["3", "5"]}], ")"}]}], "0", 
        RowBox[{
         RowBox[{"-", "Sx"}], 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["Sx", "2"], "-", 
           FractionBox["3", "5"]}], ")"}]}]},
       {
        RowBox[{
         RowBox[{"-", "Sy"}], 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["Sy", "2"], "-", 
           FractionBox["3", "5"]}], ")"}]}], 
        RowBox[{"Sx", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["Sx", "2"], "-", 
           FractionBox["3", "5"]}], ")"}]}], "0"}
      }], "\[NoBreak]", ")"}], "\[Sigma]t1uprime"}]}]}]], "Input",
 CellChangeTimes->{
  3.874312624356277*^9, {3.8743127026090107`*^9, 3.8743129571598463`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"5a2a6612-d1d8-4298-8bb0-e29afbc02080"],

Cell["\<\
Without 3 d spin - orbit coupling the spin of the 3d shell is a good quantum \
number and the series truncates at the order 2S. For a Cu atom with local \
S=1/2 one thus only finds circular dichroism, For Ni with S=1 also the linear \
dichroic term is non-zero. The term in third power of S is zero. For a Mn or \
Fe ion with S=5/2 one needs to take the expansion up to S^5. \
\>", "Text",
 CellChangeTimes->{{3.874313020594006*^9, 
  3.8743131563481216`*^9}},ExpressionUUID->"3e22bb09-d135-477f-8908-\
04a524ed01cf"],

Cell["\<\
For NiO with the spin in a 112 direction we have the conductivity tensor\
\>", "Text",
 CellChangeTimes->{{3.874313211669635*^9, 3.8743132402883587`*^9}, 
   3.8743133108917522`*^9},ExpressionUUID->"b16bbc7a-9b59-4bd7-9fd5-\
c7dc2e2d34ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"\[Sigma]Ni", "=", 
   RowBox[{
    RowBox[{"\[Sigma]Oh", "[", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["6"]], ",", 
      FractionBox["1", 
       SqrtBox["6"]], ",", 
      FractionBox["2", 
       SqrtBox["6"]]}], "]"}], "/.", 
    RowBox[{"\[Sigma]t1uprime", "\[Rule]", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.874313171778116*^9, 3.8743132324820347`*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"98b20198-b8c5-4af7-8ce9-8caedc173051"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"\[Sigma]a1g", "-", 
       FractionBox["\[Sigma]eg", "6"]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SqrtBox[
          FractionBox["2", "3"]]}], " ", "\[Sigma]t1u"}], "+", 
       FractionBox["\[Sigma]t2g", "6"]}], 
      RowBox[{
       FractionBox["\[Sigma]t1u", 
        SqrtBox["6"]], "+", 
       FractionBox["\[Sigma]t2g", "3"]}]},
     {
      RowBox[{
       RowBox[{
        SqrtBox[
         FractionBox["2", "3"]], " ", "\[Sigma]t1u"}], "+", 
       FractionBox["\[Sigma]t2g", "6"]}], 
      RowBox[{"\[Sigma]a1g", "-", 
       FractionBox["\[Sigma]eg", "6"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["\[Sigma]t1u", 
         SqrtBox["6"]]}], "+", 
       FractionBox["\[Sigma]t2g", "3"]}]},
     {
      RowBox[{
       RowBox[{"-", 
        FractionBox["\[Sigma]t1u", 
         SqrtBox["6"]]}], "+", 
       FractionBox["\[Sigma]t2g", "3"]}], 
      RowBox[{
       FractionBox["\[Sigma]t1u", 
        SqrtBox["6"]], "+", 
       FractionBox["\[Sigma]t2g", "3"]}], 
      RowBox[{"\[Sigma]a1g", "+", 
       FractionBox["\[Sigma]eg", "3"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8743131768052053`*^9, 3.874313233680264*^9}},
 CellLabel->
  "Out[83]//MatrixForm=",ExpressionUUID->"b711feb8-3f32-461f-9ea2-\
531b7c10b323"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Sigma]Ni", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", 
    RowBox[{"\[Sigma]Ni", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "2"}], "]"}], "]"}], "+", 
    RowBox[{"\[Sigma]Ni", "[", 
     RowBox[{"[", 
      RowBox[{"3", ",", "3"}], "]"}], "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.874313245771985*^9, 3.874313279390667*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"9692dff8-c6a7-42f3-848d-09e8ba480aca"],

Cell[BoxData["\[Sigma]a1g"], "Output",
 CellChangeTimes->{{3.874313267500963*^9, 3.874313279957199*^9}},
 CellLabel->"Out[85]=",ExpressionUUID->"4ed4bdb0-dbbb-4a63-9c06-b44ac9c7a629"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["3", "8"]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Sigma]Ni", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "1"}], "]"}], "]"}], "-", 
    RowBox[{"\[Sigma]Ni", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.8743132955359*^9, 3.874313301945261*^9}, {
  3.874313353686952*^9, 3.874313374392231*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"1aea32b3-db38-4eb0-be96-6d6fb4bd7e9a"],

Cell[BoxData["\[Sigma]t1u"], "Output",
 CellChangeTimes->{
  3.87431330275289*^9, {3.874313364719153*^9, 3.874313374685871*^9}},
 CellLabel->"Out[88]=",ExpressionUUID->"94c968ee-b714-4730-a0e4-3f9c232234ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["3", "2"], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Sigma]Ni", "[", 
     RowBox[{"[", 
      RowBox[{"3", ",", "2"}], "]"}], "]"}], "+", 
    RowBox[{"\[Sigma]Ni", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "3"}], "]"}], "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.8743133871974*^9, 3.874313392064039*^9}, {
  3.87431411380729*^9, 3.874314125248993*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"95951634-bb06-4f37-99d9-6015467ac754"],

Cell[BoxData["\[Sigma]t2g"], "Output",
 CellChangeTimes->{{3.874313387796777*^9, 3.874313393111802*^9}, {
  3.8743141213966837`*^9, 3.874314126228801*^9}},
 CellLabel->"Out[98]=",ExpressionUUID->"2cc0e024-3f78-4270-bc75-a5efc37e16b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"\[Sigma]Ni", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "-", 
    RowBox[{"\[Sigma]Ni", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "2"}], "]"}], "]"}], "+", 
    RowBox[{"2", 
     RowBox[{"\[Sigma]Ni", "[", 
      RowBox[{"[", 
       RowBox[{"3", ",", "3"}], "]"}], "]"}]}]}], ")"}], "]"}]], "Input",
 CellChangeTimes->{{3.874313404931685*^9, 3.874313467974873*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"4b46ef92-dbcd-41eb-8ba7-a30429548de1"],

Cell[BoxData["\[Sigma]eg"], "Output",
 CellChangeTimes->{{3.874313410831286*^9, 3.874313468278138*^9}},
 CellLabel->"Out[96]=",ExpressionUUID->"77667913-0303-4843-b9c9-8c4f2f67bdc1"]
}, Open  ]]
},
WindowSize->{1272, 1222},
WindowMargins->{{Automatic, -2334}, {Automatic, 3}},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"faea9d12-4a36-472f-a08a-458866f283e6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 360, 7, 58, "Text",ExpressionUUID->"f850d626-c07d-4e60-bb0f-9b5f255da388"],
Cell[921, 29, 2714, 88, 89, "Input",ExpressionUUID->"5a2a6612-d1d8-4298-8bb0-e29afbc02080"],
Cell[3638, 119, 527, 9, 58, "Text",ExpressionUUID->"3e22bb09-d135-477f-8908-04a524ed01cf"],
Cell[4168, 130, 249, 5, 35, "Text",ExpressionUUID->"b16bbc7a-9b59-4bd7-9fd5-c7dc2e2d34ff"],
Cell[CellGroupData[{
Cell[4442, 139, 514, 14, 53, "Input",ExpressionUUID->"98b20198-b8c5-4af7-8ce9-8caedc173051"],
Cell[4959, 155, 1732, 55, 120, "Output",ExpressionUUID->"b711feb8-3f32-461f-9ea2-531b7c10b323"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6728, 215, 543, 15, 48, "Input",ExpressionUUID->"9692dff8-c6a7-42f3-848d-09e8ba480aca"],
Cell[7274, 232, 183, 2, 34, "Output",ExpressionUUID->"4ed4bdb0-dbbb-4a63-9c06-b44ac9c7a629"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7494, 239, 501, 14, 57, "Input",ExpressionUUID->"1aea32b3-db38-4eb0-be96-6d6fb4bd7e9a"],
Cell[7998, 255, 207, 3, 34, "Output",ExpressionUUID->"94c968ee-b714-4730-a0e4-3f9c232234ca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8242, 263, 487, 13, 47, "Input",ExpressionUUID->"95951634-bb06-4f37-99d9-6015467ac754"],
Cell[8732, 278, 234, 3, 34, "Output",ExpressionUUID->"2cc0e024-3f78-4270-bc75-a5efc37e16b0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9003, 286, 589, 16, 30, "Input",ExpressionUUID->"4b46ef92-dbcd-41eb-8ba7-a30429548de1"],
Cell[9595, 304, 182, 2, 34, "Output",ExpressionUUID->"77667913-0303-4843-b9c9-8c4f2f67bdc1"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

